import { View } from "react-native";
import React, { useEffect } from "react";
import Query from "./Query/Query";
import { BASE_API_URL_STG } from "@env";
import Reviews from "./Reviews/Reviews";
import { useDispatch, useSelector } from "react-redux";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";
import CustomSpinner from "../../../../screens/Utilities/CustomSpinner/CustomSpinner";
import { getVendorProductReviews } from "../../../../redux/slices/vendor/vendorProfile";

const VendorProfile = ({ shop_alias, vendor }) => {
    const dispatch = useDispatch();

    const { vendorProductReviews, vendorProfileInfo, loading } =
        useSelector((state) => state.vendorProfile) || {};

    useEffect(() => {
        const URL = `${BASE_API_URL_STG}/user/shop/profile/${shop_alias}`;
        let isMounted = true;
        if (isMounted && loading && vendorProductReviews.length === 0) {
            dispatch(getVendorProductReviews(URL));
        }
        return () => {
            isMounted = false;
        };
    }, [shop_alias]);

    return (
        <View>
            <Query vendorProfileInfo={vendorProfileInfo} loading={loading} vendor={vendor} />
            {loading ? (
                <CustomSpinner
                    filePath={require("../../../../assets/lottie/loader2.json")}
                    size={{
                        width: dpr(60),
                        height: dpr(55),
                    }}
                />
            ) : (
                <Reviews vendorProductReviews={vendorProductReviews} />
            )}
        </View>
    );
};

export default VendorProfile;
